---
myst:
  html_meta:
    keywords: LaTeX,versions des fichiers,versions des modules,versions des packages
---
# Comment connaître les versions des fichiers utilisées dans un document ?

- La commande `\listfiles` affiche, lors de la compilation, les versions, dates, auteurs et commentaires disponibles sur les fichiers inclus. Cette commande n'est autorisée que dans le préambule.

## À quoi ça sert ?

Lorsque vous échangez un document avec quelqu'un d'autre (dans le cadre d'un développement en commun, par exemple), il est préférable que les deux correspondants disposent du même jeu de fichiers, en plus du document en question. Pour être plus précis, votre correspondant a évidemment besoin d'avoir les mêmes extensions (si vous utilisez l'extension <ctanpkg:url>, il doit aussi l'avoir, par exemple), mais il y a des cas où il devra avoir en plus les mêmes versions. Si par exemple vous disposez d'une version exempte de bogues du package `tout_nouveau_tout_neuf` mais que votre collaborateur a toujours une version antérieure, instable... vous allez vous arracher les cheveux jusqu'à ce que vous compreniez que le problème ne vient pas de votre code, mais de cette extension !

La solution la plus simple est d'utiliser la commande LaTeX `\listfiles`. Elle
écrit une liste des fichiers utilisés accompagnés de leur numéro de version dans le
terminal et dans le fichier journal ("de log"). Vous pouvez ainsi récupérer
cette liste et la transmettre avec votre fichier, et votre collaborateur n'aura
qu'à la comparer à la sienne en cas de problème.

Ainsi, la compilation du fichier suivant :

```{noedit}
\listfiles

\documentclass{article}
  \usepackage[T1]{fontenc}
  \usepackage{lmodern}
  \usepackage[french]{babel}
\begin{document}
Penser à se coucher de bonne heure.
\end{document}
```

écrira dans le terminal et dans le fichier journal (peu avant la fin) quelque
chose comme :

```text
 *File List*
 article.cls    2024/02/08 v1.4n Standard LaTeX document class
  size10.clo    2024/02/08 v1.4n Standard LaTeX file (size option)
 fontenc.sty    2021/04/29 v2.0v Standard LaTeX package
 lmodern.sty    2015/05/01 v1.6.1 Latin Modern Fonts
   babel.sty    2024/06/26 v24.7 The Babel package
  french.ldf    2024-07-25 v3.6c French support from the babel system
babel-french.tex
scalefnt.sty
   t1lmr.fd    2015/05/01 v1.6.1 Font defs for Latin Modern
l3backend-pdftex.def    2024-05-08 L3 backend support: PDF output (pdfTeX)
 ***********
```

Attention, `\listfiles` n'enregistre que les fichiers qui sont inclus par les mécanismes LaTeX « standards » (comme `\documentclass`, `\usepackage`, `\include`, `\includegraphics` et ainsi de suite). La commande `\input`, fournie par LaTeX et utilisée avec la syntaxe LaTeX, comme ceci :

```{noedit}
\input{mymacros}
```

enregistre bien les détails du fichier `mymacros.tex`, mais si vous l'utilisez avec la syntaxe d'une primitive TeX, comme ceci :

```{noedit}
\input mymacros
```

`mymacros.tex` ne sera *pas* enregistré, et ne sera donc pas répertorié par `\listfiles`, puisque vous avez contourné son mécanisme qui enregistre les appels à des fichiers.

## Comment faire une archive des fichiers utilisés ?

L'extension <ctanpkg:snapshot> vous fournit une liste des dépendances d'un document LaTeX, sous une forme que vous pourrez intégrer en tête de document. L'objectif de cette extension est de créer des copies d'archives de documents, mais elle est également utile pour simplement d'échanger des documents.

Par exemple avec le document précédent, cette extension crée un fichier `mon_document.dep` qui contient :

```{noedit}
 \RequireVersions{
    *{application}{pdfTeX}  {0000/00/00 v1.40.26}
    *{format} {LaTeX2e}     {2024-06-01 v2.e}
    *{class}  {article}     {2024/02/08 v1.4n}
    *{file}   {size10.clo}  {2024/02/08 v1.4n}
    *{package}{fontenc}     {0000/00/00 v0.0}
    *{package}{lmodern}     {2015/05/01 v1.6.1}
    *{package}{snapshot}    {2020/06/17 v2.14}
    *{package}{babel}       {2024/08/18 v24.8}
    *{file}   {french.ldf}  {2024-07-25 v3.6c}
    *{file}   {babel-french.tex}{0000/00/00 v0.0}
    *{package}{scalefnt}    {0000/00/00 v0.0}
    *{file}   {t1lmr.fd}    {2015/05/01 v1.6.1}
    *{file}   {l3backend-pdftex.def}{2024-05-08 v3}
  }
```

Vous pourrez ensuite appeler le package <ctanpkg:bundledoc>, qui utilisera cet « instantané » pour construire une archive (une fichier `.tar.gz` ou `.zip`) contenant les fichiers nécessaires à votre document ; il est fourni avec des fichiers de configuration pour une utilisation avec TeX Live sous Unix ou MiKTeX sous Windows. Il est surtout utile lorsque vous envoyez la première copie d'un document à un collaborateur.

## Comment surveiller la compilation ?

Le programme <texdoc:mkjobtexmf> lance `tex` (ou autre) et surveille quels fichiers sont utilisés pendant la compilation, soit grâce à l'option `-recorder` de `tex`, soit en appelant la commande Unix [strace](wpfr:Strace) pour garder un œil sur ce que fait `tex`. Les fichiers ainsi trouvés sont copiés (ou liés) dans un répertoire de type `texmf`, qui pourra être sauvegardé pour être transmis ou archivé.

:::{sources}
- [All the files used by this document](faquk:FAQ-filesused),
- [Embed nicely formatted « `\listfiles` » into document](https://tex.stackexchange.com/questions/265726/embed-nicely-formatted-listfiles-into-document).
:::
