# Preset Gradients

All preset gradients are in the domain [0..1]. Uniform B-splines is used to interpolate the colors.

![img](docs/images/rgb-plot.png)

```rust
use colorgrad::Gradient;

let g = colorgrad::preset::viridis();

assert_eq!(g.domain(), (0.0, 1.0));

println!("{}", g.at(0.27).to_css_hex());

for color in g.colors_iter(35) {
    println!("{:?}", color.to_rgba8());
}
```

## Diverging

`colorgrad::preset::br_bg()`
![img](docs/images/preset/br_bg.png)

`colorgrad::preset::pr_gn()`
![img](docs/images/preset/pr_gn.png)

`colorgrad::preset::pi_yg()`
![img](docs/images/preset/pi_yg.png)

`colorgrad::preset::pu_or()`
![img](docs/images/preset/pu_or.png)

`colorgrad::preset::rd_bu()`
![img](docs/images/preset/rd_bu.png)

`colorgrad::preset::rd_gy()`
![img](docs/images/preset/rd_gy.png)

`colorgrad::preset::rd_yl_bu()`
![img](docs/images/preset/rd_yl_bu.png)

`colorgrad::preset::rd_yl_gn()`
![img](docs/images/preset/rd_yl_gn.png)

`colorgrad::preset::spectral()`
![img](docs/images/preset/spectral.png)

## Sequential (Single Hue)

`colorgrad::preset::blues()`
![img](docs/images/preset/blues.png)

`colorgrad::preset::greens()`
![img](docs/images/preset/greens.png)

`colorgrad::preset::greys()`
![img](docs/images/preset/greys.png)

`colorgrad::preset::oranges()`
![img](docs/images/preset/oranges.png)

`colorgrad::preset::purples()`
![img](docs/images/preset/purples.png)

`colorgrad::preset::reds()`
![img](docs/images/preset/reds.png)

## Sequential (Multi-Hue)

`colorgrad::preset::turbo()`
![img](docs/images/preset/turbo.png)

`colorgrad::preset::viridis()`
![img](docs/images/preset/viridis.png)

`colorgrad::preset::inferno()`
![img](docs/images/preset/inferno.png)

`colorgrad::preset::magma()`
![img](docs/images/preset/magma.png)

`colorgrad::preset::plasma()`
![img](docs/images/preset/plasma.png)

`colorgrad::preset::cividis()`
![img](docs/images/preset/cividis.png)

`colorgrad::preset::warm()`
![img](docs/images/preset/warm.png)

`colorgrad::preset::cool()`
![img](docs/images/preset/cool.png)

`colorgrad::preset::cubehelix_default()`
![img](docs/images/preset/cubehelix_default.png)

`colorgrad::preset::bu_gn()`
![img](docs/images/preset/bu_gn.png)

`colorgrad::preset::bu_pu()`
![img](docs/images/preset/bu_pu.png)

`colorgrad::preset::gn_bu()`
![img](docs/images/preset/gn_bu.png)

`colorgrad::preset::or_rd()`
![img](docs/images/preset/or_rd.png)

`colorgrad::preset::pu_bu_gn()`
![img](docs/images/preset/pu_bu_gn.png)

`colorgrad::preset::pu_bu()`
![img](docs/images/preset/pu_bu.png)

`colorgrad::preset::pu_rd()`
![img](docs/images/preset/pu_rd.png)

`colorgrad::preset::rd_pu()`
![img](docs/images/preset/rd_pu.png)

`colorgrad::preset::yl_gn_bu()`
![img](docs/images/preset/yl_gn_bu.png)

`colorgrad::preset::yl_gn()`
![img](docs/images/preset/yl_gn.png)

`colorgrad::preset::yl_or_br()`
![img](docs/images/preset/yl_or_br.png)

`colorgrad::preset::yl_or_rd()`
![img](docs/images/preset/yl_or_rd.png)

## Cyclical

`colorgrad::preset::rainbow()`
![img](docs/images/preset/rainbow.png)

`colorgrad::preset::sinebow()`
![img](docs/images/preset/sinebow.png)

