# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2025 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from Unit.idl.

use strict;

package Raritan::RPC::pdumodel::Unit;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "pdumodel.Unit:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::pdumodel::Unit::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

sub identify($$) {
    my ($self, $seconds) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'seconds'} = 1 * $seconds;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'identify', $args);
}

sub muteBuzzer($$) {
    my ($self, $mute) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'mute'} = ($mute) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'muteBuzzer', $args);
}

sub testBuzzer($$) {
    my ($self, $on) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'on'} = ($on) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'testBuzzer', $args);
}

sub testButtonState($$) {
    my ($self, $button) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'button'} = 1 * $button;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'testButtonState', $args);
    my $_ret_;
    $_ret_ = ($rsp->{'_ret_'}) ? 1 : 0;
    return $_ret_;
}

sub testLEDSequence($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'testLEDSequence', $args);
}

use Raritan::RPC::pdumodel::Unit::DisplayInfo;

sub getDisplayInfo($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getDisplayInfo', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::pdumodel::Unit::DisplayInfo::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('pdumodel.Unit', 1, 0, 0, 'Raritan::RPC::pdumodel::Unit');
1;
