// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ServerSSLCert.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.cert {
  public class ServerSSLCert_3_0_0 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("cert.ServerSSLCert:3.0.0", null);

    public ServerSSLCert_3_0_0(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public ServerSSLCert_3_0_0(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new ServerSSLCert_3_0_0 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new ServerSSLCert_3_0_0(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int SUCCESS = 0;

    public const int ERR_GEN_KEY_LEN_INVALID = 100;

    public const int ERR_GEN_CSR_OR_CERT_PENDING = 101;

    public const int ERR_GEN_KEY_GEN_FAILED = 102;

    public const int ERR_GEN_KEY_TYPE_INVALID = 103;

    public const int ERR_GEN_ELLIPTIC_CURVE_INVALID = 104;

    public const int ERR_INSTALL_KEY_MISSING = 200;

    public const int ERR_INSTALL_CERT_MISSING = 201;

    public const int ERR_INSTALL_CERT_FORMAT_INVALID = 202;

    public const int ERR_INSTALL_CERT_KEY_MISMATCH = 203;

    public const int ERR_INSTALL_KEY_FORMAT_INVALID = 204;

    public class CommonAttributes : ICloneable {
      public object Clone() {
        CommonAttributes copy = new CommonAttributes();
        copy.country = this.country;
        copy.stateOrProvince = this.stateOrProvince;
        copy.locality = this.locality;
        copy.organization = this.organization;
        copy.organizationalUnit = this.organizationalUnit;
        copy.commonName = this.commonName;
        copy.emailAddress = this.emailAddress;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["country"] = this.country;
        json["stateOrProvince"] = this.stateOrProvince;
        json["locality"] = this.locality;
        json["organization"] = this.organization;
        json["organizationalUnit"] = this.organizationalUnit;
        json["commonName"] = this.commonName;
        json["emailAddress"] = this.emailAddress;
        return json;
      }

      public static CommonAttributes Decode(LightJson.JsonObject json, Agent agent) {
        CommonAttributes inst = new CommonAttributes();
        inst.country = (string)json["country"];
        inst.stateOrProvince = (string)json["stateOrProvince"];
        inst.locality = (string)json["locality"];
        inst.organization = (string)json["organization"];
        inst.organizationalUnit = (string)json["organizationalUnit"];
        inst.commonName = (string)json["commonName"];
        inst.emailAddress = (string)json["emailAddress"];
        return inst;
      }

      public string country = "";
      public string stateOrProvince = "";
      public string locality = "";
      public string organization = "";
      public string organizationalUnit = "";
      public string commonName = "";
      public string emailAddress = "";
    }

    public enum KeyType {
      KEY_TYPE_UNKNOWN,
      KEY_TYPE_RSA,
      KEY_TYPE_ECDSA,
    }

    public enum EllipticCurve {
      EC_CURVE_UNKNOWN,
      EC_CURVE_NIST_P256,
      EC_CURVE_NIST_P384,
      EC_CURVE_NIST_P521,
    }

    public class ReqInfo : ICloneable {
      public object Clone() {
        ReqInfo copy = new ReqInfo();
        copy.subject = this.subject;
        copy.names = this.names;
        copy.keyType = this.keyType;
        copy.ellipticCurve = this.ellipticCurve;
        copy.rsaKeyLength = this.rsaKeyLength;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["subject"] = this.subject.Encode();
        json["names"] = new JsonArray(this.names.Select(
          _value => (JsonValue)(_value)));
        json["keyType"] = (int)this.keyType;
        json["ellipticCurve"] = (int)this.ellipticCurve;
        json["rsaKeyLength"] = this.rsaKeyLength;
        return json;
      }

      public static ReqInfo Decode(LightJson.JsonObject json, Agent agent) {
        ReqInfo inst = new ReqInfo();
        inst.subject = Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CommonAttributes.Decode(json["subject"], agent);
        inst.names = new System.Collections.Generic.List<string>(json["names"].AsJsonArray.Select(
          _value => (string)_value));
        inst.keyType = (Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.KeyType)(int)json["keyType"];
        inst.ellipticCurve = (Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.EllipticCurve)(int)json["ellipticCurve"];
        inst.rsaKeyLength = (int)json["rsaKeyLength"];
        return inst;
      }

      public Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CommonAttributes subject = new Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CommonAttributes();
      public System.Collections.Generic.IEnumerable<string> names = new System.Collections.Generic.List<string>();
      public Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.KeyType keyType = Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.KeyType.KEY_TYPE_UNKNOWN;
      public Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.EllipticCurve ellipticCurve = Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.EllipticCurve.EC_CURVE_UNKNOWN;
      public int rsaKeyLength = 0;
    }

    public class CertInfo : ICloneable {
      public object Clone() {
        CertInfo copy = new CertInfo();
        copy.subject = this.subject;
        copy.issuer = this.issuer;
        copy.names = this.names;
        copy.invalidBefore = this.invalidBefore;
        copy.invalidAfter = this.invalidAfter;
        copy.serialNumber = this.serialNumber;
        copy.keyType = this.keyType;
        copy.ellipticCurve = this.ellipticCurve;
        copy.rsaKeyLength = this.rsaKeyLength;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["subject"] = this.subject.Encode();
        json["issuer"] = this.issuer.Encode();
        json["names"] = new JsonArray(this.names.Select(
          _value => (JsonValue)(_value)));
        json["invalidBefore"] = this.invalidBefore;
        json["invalidAfter"] = this.invalidAfter;
        json["serialNumber"] = this.serialNumber;
        json["keyType"] = (int)this.keyType;
        json["ellipticCurve"] = (int)this.ellipticCurve;
        json["rsaKeyLength"] = this.rsaKeyLength;
        return json;
      }

      public static CertInfo Decode(LightJson.JsonObject json, Agent agent) {
        CertInfo inst = new CertInfo();
        inst.subject = Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CommonAttributes.Decode(json["subject"], agent);
        inst.issuer = Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CommonAttributes.Decode(json["issuer"], agent);
        inst.names = new System.Collections.Generic.List<string>(json["names"].AsJsonArray.Select(
          _value => (string)_value));
        inst.invalidBefore = (string)json["invalidBefore"];
        inst.invalidAfter = (string)json["invalidAfter"];
        inst.serialNumber = (string)json["serialNumber"];
        inst.keyType = (Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.KeyType)(int)json["keyType"];
        inst.ellipticCurve = (Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.EllipticCurve)(int)json["ellipticCurve"];
        inst.rsaKeyLength = (int)json["rsaKeyLength"];
        return inst;
      }

      public Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CommonAttributes subject = new Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CommonAttributes();
      public Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CommonAttributes issuer = new Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CommonAttributes();
      public System.Collections.Generic.IEnumerable<string> names = new System.Collections.Generic.List<string>();
      public string invalidBefore = "";
      public string invalidAfter = "";
      public string serialNumber = "";
      public Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.KeyType keyType = Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.KeyType.KEY_TYPE_UNKNOWN;
      public Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.EllipticCurve ellipticCurve = Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.EllipticCurve.EC_CURVE_UNKNOWN;
      public int rsaKeyLength = 0;
    }

    public class Info : ICloneable {
      public object Clone() {
        Info copy = new Info();
        copy.havePendingReq = this.havePendingReq;
        copy.havePendingCert = this.havePendingCert;
        copy.pendingReqInfo = this.pendingReqInfo;
        copy.pendingCertInfo = this.pendingCertInfo;
        copy.pendingCertChainInfos = this.pendingCertChainInfos;
        copy.activeCertInfo = this.activeCertInfo;
        copy.activeCertChainInfos = this.activeCertChainInfos;
        copy.maxSignDays = this.maxSignDays;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["havePendingReq"] = this.havePendingReq;
        json["havePendingCert"] = this.havePendingCert;
        json["pendingReqInfo"] = this.pendingReqInfo.Encode();
        json["pendingCertInfo"] = this.pendingCertInfo.Encode();
        json["pendingCertChainInfos"] = new JsonArray(this.pendingCertChainInfos.Select(
          _value => (JsonValue)(_value.Encode())));
        json["activeCertInfo"] = this.activeCertInfo.Encode();
        json["activeCertChainInfos"] = new JsonArray(this.activeCertChainInfos.Select(
          _value => (JsonValue)(_value.Encode())));
        json["maxSignDays"] = this.maxSignDays;
        return json;
      }

      public static Info Decode(LightJson.JsonObject json, Agent agent) {
        Info inst = new Info();
        inst.havePendingReq = (bool)json["havePendingReq"];
        inst.havePendingCert = (bool)json["havePendingCert"];
        inst.pendingReqInfo = Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.ReqInfo.Decode(json["pendingReqInfo"], agent);
        inst.pendingCertInfo = Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CertInfo.Decode(json["pendingCertInfo"], agent);
        inst.pendingCertChainInfos = new System.Collections.Generic.List<Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CertInfo>(json["pendingCertChainInfos"].AsJsonArray.Select(
          _value => Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CertInfo.Decode(_value, agent)));
        inst.activeCertInfo = Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CertInfo.Decode(json["activeCertInfo"], agent);
        inst.activeCertChainInfos = new System.Collections.Generic.List<Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CertInfo>(json["activeCertChainInfos"].AsJsonArray.Select(
          _value => Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CertInfo.Decode(_value, agent)));
        inst.maxSignDays = (int)json["maxSignDays"];
        return inst;
      }

      public bool havePendingReq = false;
      public bool havePendingCert = false;
      public Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.ReqInfo pendingReqInfo = new Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.ReqInfo();
      public Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CertInfo pendingCertInfo = new Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CertInfo();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CertInfo> pendingCertChainInfos = new System.Collections.Generic.List<Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CertInfo>();
      public Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CertInfo activeCertInfo = new Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CertInfo();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CertInfo> activeCertChainInfos = new System.Collections.Generic.List<Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.CertInfo>();
      public int maxSignDays = 0;
    }

    public class GenerateUnsignedKeyPairResult {
      public int _ret_;
    }

    public GenerateUnsignedKeyPairResult generateUnsignedKeyPair(Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.ReqInfo reqInfo, string challenge) {
      var _parameters = new LightJson.JsonObject();
      _parameters["reqInfo"] = reqInfo.Encode();
      _parameters["challenge"] = challenge;

      var _result = RpcCall("generateUnsignedKeyPair", _parameters);
      var _ret = new GenerateUnsignedKeyPairResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest generateUnsignedKeyPair(Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.ReqInfo reqInfo, string challenge, AsyncRpcResponse<GenerateUnsignedKeyPairResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return generateUnsignedKeyPair(reqInfo, challenge, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest generateUnsignedKeyPair(Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.ReqInfo reqInfo, string challenge, AsyncRpcResponse<GenerateUnsignedKeyPairResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["reqInfo"] = reqInfo.Encode();
        _parameters["challenge"] = challenge;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("generateUnsignedKeyPair", _parameters,
        _result => {
          try {
            var _ret = new GenerateUnsignedKeyPairResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GenerateSelfSignedKeyPairResult {
      public int _ret_;
    }

    public GenerateSelfSignedKeyPairResult generateSelfSignedKeyPair(Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.ReqInfo reqInfo, int days) {
      var _parameters = new LightJson.JsonObject();
      _parameters["reqInfo"] = reqInfo.Encode();
      _parameters["days"] = days;

      var _result = RpcCall("generateSelfSignedKeyPair", _parameters);
      var _ret = new GenerateSelfSignedKeyPairResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest generateSelfSignedKeyPair(Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.ReqInfo reqInfo, int days, AsyncRpcResponse<GenerateSelfSignedKeyPairResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return generateSelfSignedKeyPair(reqInfo, days, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest generateSelfSignedKeyPair(Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.ReqInfo reqInfo, int days, AsyncRpcResponse<GenerateSelfSignedKeyPairResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["reqInfo"] = reqInfo.Encode();
        _parameters["days"] = days;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("generateSelfSignedKeyPair", _parameters,
        _result => {
          try {
            var _ret = new GenerateSelfSignedKeyPairResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DeletePendingResult {
    }

    public DeletePendingResult deletePending() {
      JsonObject _parameters = null;
      var _result = RpcCall("deletePending", _parameters);
      var _ret = new DeletePendingResult();
      return _ret;
    }

    public AsyncRequest deletePending(AsyncRpcResponse<DeletePendingResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return deletePending(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest deletePending(AsyncRpcResponse<DeletePendingResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("deletePending", _parameters,
        _result => {
          try {
            var _ret = new DeletePendingResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetInfoResult {
      public Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.Info info;
    }

    public GetInfoResult getInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInfo", _parameters);
      var _ret = new GetInfoResult();
      _ret.info = Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.Info.Decode(_result["info"], agent);
      return _ret;
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInfo", _parameters,
        _result => {
          try {
            var _ret = new GetInfoResult();
            _ret.info = Com.Raritan.Idl.cert.ServerSSLCert_3_0_0.Info.Decode(_result["info"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class InstallPendingKeyPairResult {
      public int _ret_;
    }

    public InstallPendingKeyPairResult installPendingKeyPair() {
      JsonObject _parameters = null;
      var _result = RpcCall("installPendingKeyPair", _parameters);
      var _ret = new InstallPendingKeyPairResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest installPendingKeyPair(AsyncRpcResponse<InstallPendingKeyPairResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return installPendingKeyPair(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest installPendingKeyPair(AsyncRpcResponse<InstallPendingKeyPairResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("installPendingKeyPair", _parameters,
        _result => {
          try {
            var _ret = new InstallPendingKeyPairResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
