% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoxCox.R
\name{step_BoxCox}
\alias{step_BoxCox}
\title{Box-Cox Transformation for Non-Negative Data}
\usage{
step_BoxCox(recipe, ..., role = NA, trained = FALSE, lambdas = NULL,
  limits = c(-5, 5), nunique = 5)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of 
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are 
affected by the step. See \code{\link{selections}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing 
have been estimated.}

\item{lambdas}{A numeric vector of transformation values. This is
\code{NULL} until computed by \code{\link{prep.recipe}}.}

\item{limits}{A length 2 numeric vector defining the range to compute the
transformation parameter lambda.}

\item{nunique}{An integer where data that have less possible values will
not be evaluate for a transformation.}
}
\value{
An updated version of \code{recipe} with the
  new step added to the sequence of existing steps (if any).
}
\description{
\code{step_BoxCox} creates a \emph{specification} of a recipe step that will
   transform data using a simple Box-Cox transformation.
}
\details{
The Box-Cox transformation, which requires a strictly positive
  variable, can be used to rescale a variable to be more similar to a
 normal distribution. In this package, the partial log-likelihood function
 is directly optimized within a reasonable set of transformation values
 (which can be changed by the user).

This transformation is typically done on the outcome variable using the
  residuals for a statistical model (such as ordinary least squares).
  Here, a simple null model (intercept only) is used to apply the
  transformation to the \emph{predictor} variables individually. This can
  have the effect of making the variable distributions more symmetric.

If the transformation parameters are estimated to be very closed to the
  bounds, or if the optimization fails, a value of \code{NA} is used and
  no transformation is applied.
}
\examples{

rec <- recipe(~ ., data = as.data.frame(state.x77))

bc_trans <- step_BoxCox(rec, all_numeric())

bc_estimates <- prep(bc_trans, training = as.data.frame(state.x77))

bc_data <- bake(bc_estimates, as.data.frame(state.x77))

plot(density(state.x77[, "Illiteracy"]), main = "before")
plot(density(bc_data$Illiteracy), main = "after")
}
\references{
Sakia, R. M. (1992). The Box-Cox transformation technique:
  A review. \emph{The Statistician}, 169-178..
}
\seealso{
\code{\link{step_YeoJohnson}} \code{\link{recipe}}
  \code{\link{prep.recipe}} \code{\link{bake.recipe}}
}
\concept{
preprocessing transformation_methods
}
\keyword{datagen}
