% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\docType{package}
\name{Luminescence-package}
\alias{Luminescence-package}
\alias{Luminescence}
\title{Comprehensive Luminescence Dating Data Analysis\cr
\if{html}{
\figure{Luminescence_logo.png}{options: width="75" alt="r-luminescence.org"}
}}
\description{
A collection of various R functions for the purpose of luminescence dating
data analysis. This includes, amongst others, data import, export,
application of age models, curve deconvolution, sequence analysis and
plotting of equivalent dose distributions.
}
\details{
\strong{Supervisor of the initial version in 2012}

Markus Fuchs, Justus-Liebig-University Giessen, Germany

\strong{Support contact}
\itemize{
\item \email{developers@r-luminescence.org}
\item \url{https://github.com/R-Lum/Luminescence/discussions}
}

\strong{Bug reporting}
\itemize{
\item \email{developers@r-luminescence.org} or
\item \url{https://github.com/R-Lum/Luminescence/issues}
}

\strong{Project website}
\itemize{
\item \url{https://r-luminescence.org}
}

\strong{Project source code repository}
\itemize{
\item \url{https://github.com/R-Lum/Luminescence}
}

\strong{Related package projects}
\itemize{
\item \url{https://cran.r-project.org/package=RLumShiny}
\item \url{https://cran.r-project.org/package=RLumModel}
\item \url{https://cran.r-project.org/package=RLumCarlo}
\item \url{https://cran.r-project.org/package=RCarb}
}

\strong{Funding}
\itemize{
\item 2011-2013:  The initial version of the package was developed, while Sebastian Kreutzer
was funded through the DFG programme "Rekonstruktion der Umweltbedingungen
des Spätpleistozäns in Mittelsachsen anhand von Löss-Paläobodensequenzen"
(DFG id: 46526743)
\item 2014-2018: Cooperation and personal exchange between the developers is gratefully
funded by the DFG (SCHM 3051/3-1) in the framework of the program
"Scientific Networks". Project title: "RLum.Network: Ein
Wissenschaftsnetzwerk zur Analyse von Lumineszenzdaten mit R" (2014-2018)
\item 05/2014-12/2019: The work of Sebastian Kreutzer as maintainer of the package was supported
by LabEx LaScArBx (ANR - n. ANR-10-LABX-52).
\item 01/2020-04/2022: Sebastian Kreutzer as maintainer of the package has received funding
from the European Union’s Horizon 2020 research and innovation programme under
the Marie Skłodowska-Curie grant agreement No 844457 (CREDit), and could continue
maintaining the package.
\item since 03/2023: Sebastian Kreutzer as maintainer of the package receives funding from the
DFG Heisenberg programme No 505822867.
\item since 08/2024: The future and sustainable development of 'Luminescence'
towards better reproducibility and usability is supported through the DFG
programme "REPLAY: REProducible Luminescence Data AnalYses" No 528704761,
led by Dr Sebastian Kreutzer (PI at Heidelberg University, DE) and Dr Thomas
Kolb (PI at Justus-Liebig-University Giessen, DE).
\item All other authors gratefully received additional funding from various public funding bodies.
}
}
\references{
Dietze, M., Kreutzer, S., Fuchs, M.C., Burow, C., Fischer, M.,
Schmidt, C., 2013. A practical guide to the R package Luminescence.
Ancient TL, 31 (1), 11-18.

Dietze, M., Kreutzer, S., Burow, C., Fuchs, M.C., Fischer, M., Schmidt, C., 2016. The abanico plot:
visualising chronometric data with individual standard errors. Quaternary Geochronology 31, 1-7.
https://doi.org/10.1016/j.quageo.2015.09.003

Fuchs, M.C., Kreutzer, S., Burow, C., Dietze, M., Fischer, M., Schmidt, C.,
Fuchs, M., 2015. Data processing in luminescence dating analysis: An
exemplary workflow using the R package 'Luminescence'. Quaternary
International, 362,8-13. https://doi.org/10.1016/j.quaint.2014.06.034

Kreutzer, S., Schmidt, C., Fuchs, M.C., Dietze, M., Fischer, M., Fuchs, M.,
2012. Introducing an R package for luminescence dating analysis. Ancient TL,
30 (1), 1-8.

Mercier, N., Kreutzer, S., Christophe, C., Guérin, G., Guibert, P., Lahaye, C., Lanos, P., Philippe, A.,
Tribolo, C., 2016. Bayesian statistics in luminescence dating: The 'baSAR'-model and its
implementation in the R package 'Luminescence'. Ancient TL 34 (2), 14-21.

Mercier, N., Galharret, J.-M., Tribolo, C., Kreutzer, S., Philippe, A., 2022.
Luminescence age calculation through Bayesian convolution of equivalent dose
and dose-rate distributions: the De_Dr model.
Geochronology 4, 297–310. https://doi.org/10.5194/gchron-4-297-2022

Smedley, R.K., 2015. A new R function for the Internal External Uncertainty (IEU) model.
Ancient TL, 33 (1), 16-21.

King, E.G., Burow, C., Roberts, H., Pearce, N.J.G., 2018. Age determination
using feldspar: evaluating fading-correction model performance. Radiation Measurements 119, 58-73.
https://doi.org/10.1016/j.radmeas.2018.07.013
}
\seealso{
Useful links:
\itemize{
  \item \url{https://r-lum.github.io/Luminescence/}
  \item Report bugs at \url{https://github.com/R-Lum/Luminescence/issues}
}

}
\author{
\strong{Maintainer}: Sebastian Kreutzer \email{maintainer_luminescence@r-luminescence.org} (\href{https://orcid.org/0000-0002-0734-2199}{ORCID}) [translator, data contributor]

Authors:
\itemize{
  \item Christoph Burow (\href{https://orcid.org/0000-0002-5023-4046}{ORCID}) [translator, data contributor]
  \item Michael Dietze (\href{https://orcid.org/0000-0001-6063-1726}{ORCID})
  \item Margret C. Fuchs (\href{https://orcid.org/0000-0001-7210-1132}{ORCID})
  \item Christoph Schmidt (\href{https://orcid.org/0000-0002-2309-3209}{ORCID})
  \item Manfred Fischer [translator]
  \item Johannes Friedrich (\href{https://orcid.org/0000-0002-0805-9547}{ORCID})
  \item Norbert Mercier (\href{https://orcid.org/0000-0002-6375-9108}{ORCID})
  \item Anne Philippe (\href{https://orcid.org/0000-0002-5331-5087}{ORCID})
  \item Svenja Riedesel (\href{https://orcid.org/0000-0003-2936-8776}{ORCID})
  \item Martin Autzen (\href{https://orcid.org/0000-0001-6249-426X}{ORCID})
  \item Dirk Mittelstrass (\href{https://orcid.org/0000-0002-9567-8791}{ORCID})
  \item Harrison J. Gray (\href{https://orcid.org/0000-0002-4555-7473}{ORCID})
  \item Jean-Michel Galharret (\href{https://orcid.org/0000-0003-2219-8727}{ORCID})
  \item Marco Colombo (\href{https://orcid.org/0000-0001-6672-0623}{ORCID})
  \item Luc Steinbuch (\href{https://orcid.org/0000-0001-6484-0920}{ORCID})
  \item Anna-Maartje de Boer (\href{https://orcid.org/0000-0002-7359-6939}{ORCID})
}

Other contributors:
\itemize{
  \item Rachel K. Smedley (\href{https://orcid.org/0000-0001-7773-5193}{ORCID}) [contributor]
  \item Claire Christophe [contributor]
  \item Antoine Zink (\href{https://orcid.org/0000-0001-7146-1101}{ORCID}) [contributor]
  \item Julie Durcan (\href{https://orcid.org/0000-0001-8724-8022}{ORCID}) [contributor]
  \item Georgina E. King (\href{https://orcid.org/0000-0003-1059-8192}{ORCID}) [contributor, data contributor]
  \item Guillaume Guérin (\href{https://orcid.org/0000-0001-6298-5579}{ORCID}) [contributor]
  \item Pierre Guibert (\href{https://orcid.org/0000-0001-8969-8684}{ORCID}) [contributor]
  \item Markus Fuchs (\href{https://orcid.org/0000-0003-4669-6528}{ORCID}) [thesis advisor]
}

}
\keyword{package}
