# Regex

[![Build Status](https://img.shields.io/github/actions/workflow/status/nitely/nim-regex/ci.yml?style=flat-square)](https://github.com/nitely/nim-regex/actions?query=workflow%3ACI)
[![licence](https://img.shields.io/github/license/nitely/nim-regex.svg?style=flat-square)](https://raw.githubusercontent.com/nitely/nim-regex/master/LICENSE)

A library for parsing, compiling, and executing regular expressions at both runtime and compile-time.

Features:

* The match time is linear in the length of the input string
* Supports compiling regex at compile-time
* Supports matching at compile-time
* Unicode level-1 support
* Descriptive error messages
* PCRE syntax and semantics

## Install

```
nimble install regex
```

# Compatibility

Nim +1.6.0

## Docs

[Read the docs](https://nitely.github.io/nim-regex/)

## Tests

```
nimble test
```

## Debugging

Compile with `-d:regexDotDir:.` to generate [dot files](https://en.wikipedia.org/wiki/DOT_(graph_description_language)) of the regexes (NFAs) within the nim file. A dot file can be viewed in [Graphviz](https://dreampuf.github.io/GraphvizOnline/). Requires Nim +1.2.

## LICENSE

MIT
